*******************************************************************************
*                        680xx Grundprogramm drucker                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                           Drucker-Ansteuerung                               *
*******************************************************************************


* Druckeransteuerungen

* Fr Epson oder kompatiblen Drucker ausgelegt (Befehle knnen gendert werden)

druckbef:
 dc.b $1b,'@',$ff               * Drucker initialisieren
 dc.b $1b,'l',$ff               * Linker Rand
 dc.b $1b,15,$ff                * Schmaldruck an
 dc.b $1b,'W',1                 * Breitdruck an
 dc.b $1b,'P',$ff               * Pica
 dc.b $1b,'M',$ff               * Elite
 dc.b $1b,'U',0                 * Bidirektional
 dc.b $1b,'U',1                 * Unidirektional
 dc.b $1b,'s',0                 * Normale Druckgeschwindigkeit
 dc.b $1b,'s',1                 * Halbe Druckgeschwindigkeit
 dc.b $1b,'F',$ff               * Fettdruck aus
 dc.b $1b,'E',$ff               * Fettdruck an
 dc.b $1b,'H',$ff               * Doppeldruck aus
 dc.b $1b,'G',$ff               * Doppeldruck an
 dc.b $1b,'p',0                 * Proportionaldruck aus
 dc.b $1b,'p',1                 * Proportionaldruck an
 dc.b $1b,'5',$ff               * Kursivdruck aus
 dc.b $1b,'4',$ff               * Kursivdruck an
 dc.b $1b,9,$ff                 * Papiererkennung an
 dc.b $1b,8,$ff                 * Papiererkennung aus
 dc.b $1b,'R',0                 * Amerikanischer Zeichensatz
 dc.b $1b,'R',2                 * Deutscher Zeichensatz

drbefanz equ (*-druckbef)/3

drbefinit:                      * Tabelle der Druckerbefehle ins Ram bertragen
 lea druckbef(pc),a0            * Quelle
 lea drbeftab(a5),a1            * Ziel
 moveq #drbefanz*3-1,d7         * 22 Befehle mit je 3 Byte
drbefilp:
 move.b (a0)+,(a1)+             * bertragen
dbra d7,drbefilp
rts

amerdr:                         * Zeichensatz auf amerikanisch
 movem.l d0/d7/a0,-(a7)
 bclr.b #2,dflag0(a5)           * Bit lschen als Merker
 lea drbeftab+3*20(a5),a0
 bsr.s drbeflo                  * Amerikanischer Zeichensatz eingeschaltet
 movem.l (a7)+,d0/d7/a0
rts

deutdr:                         * Zeichensatz auf deutsch
 movem.l d0/d7/a0,-(a7)
 bset.b #2,dflag0(a5)           * Bit setzen als Merker
 lea drbeftab+3*21(a5),a0
 bsr.s drbeflo                  * Deutscher Zeichensatz eingeschaltet
 movem.l (a7)+,d0/d7/a0
rts

drbeflo:                        * Einen Befehl bertragen
 moveq #3-1,d7                  * Maximal 3 Byte
drbeflo0:
 move.b (a0)+,d0                * Byte holen
 cmp.b #$ff,d0
 beq.s drbeflo1                 * $ff, dann Ende
 bsr lo2                        * An Drucker
dbra d7,drbeflo0
drbeflo1:
rts

initdr:                         * Alle Druckerbefehle initialisieren
 lea drbeftab(a5),a0
 bsr.s drbeflo                  * Druckerinit
 lea drbeftab+3(a5),a0
 bsr.s drbeflo                  * Linker Rand
 move.b dflag3(a5),d0
 bsr lo2
 move.b dflag1(a5),d0
 and.b #3,d0
 beq.s initdr1                  * Kein Breit- oder Schmaldruck
 lea drbeftab+3*2(a5),a0        * Schmaldruck
 btst #1,d0
 beq.s initdr0
 addq.l #3,a0                   * Breitdruck
initdr0:
 bsr.s drbeflo
initdr1:
 lea drbeftab+3*4(a5),a1
 moveq #3-1,d6                  * Pica/Elite
initdr2:                        * Bidirektional/Unidirektional
 movea.l a1,a0                  * Normale Geschwindigkeit/ Langsamer Druck
 moveq #4,d0
 sub d6,d0
 btst.b d0,dflag1(a5)
 beq.s initdr3
 addq.l #3,a0
initdr3:
 bsr.s drbeflo
 addq.l #6,a1
dbra d6,initdr2
 moveq #5-1,d6                  * Fettdruck aus/an
initdr4:                        * Doppeldruck aus/an
 movea.l a1,a0                  * Proportionaldruck aus/an
 move d6,d0                     * Kursivdruck aus/an
 addq #3,d0                     * Papiererkennung an/aus
 btst.b d0,dflag0(a5)
 beq.s initdr5
 addq.l #3,a0
initdr5:
 bsr.s drbeflo
 addq.l #6,a1
dbra d6,initdr4
 lea drsave(a5),a0
 moveq #19-1,d7
 bsr drbeflo0                   * Selbstdefinierte Werte bergeben
 btst.b #0,dflag0(a5)
 bne deutdr                     * Deutscher Zeichensatz
bra amerdr                      * Amerikanischer Zeichensatz oder NDR

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             